/*
 * Decompiled with CFR 0.152.
 */
package org.tomgr.clientmods.thirdperson;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.RenderVector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmClientMod;
import org.gotti.wurmunlimited.modsupport.console.ConsoleListener;
import org.gotti.wurmunlimited.modsupport.console.ModConsole;

public class ThirdPerson
implements WurmClientMod,
Initable,
PreInitable,
ConsoleListener {
    private boolean tpActive = false;
    private static Logger logger = Logger.getLogger(ThirdPerson.class.getName());
    private float dist = 4.0f;
    private float pitch = 45.0f;
    private float zoomFactor = 1.0f;
    private float xOffset = 0.0f;
    private static final float ZOOM_MAX = 2.5f;
    private static final float ZOOM_MIN = 0.0f;
    private static final float PITCH_MAX = 89.9f;
    private static final float PITCH_MIN = 30.0f;

    public void preInit() {
    }

    public void init() {
        HookManager.getInstance().registerHook("com.wurmonline.client.renderer.WorldRender", "calculateCameraOffset", null, new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        method.invoke(proxy, args);
                        if (ThirdPerson.this.tpActive) {
                            RenderVector camera = (RenderVector)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"cameraOffset"));
                            World world = (World)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"world"));
                            float x = camera.getX();
                            float y = camera.getY();
                            float z = camera.getZ();
                            double yaw = Math.atan2(z, x);
                            RenderVector target = new RenderVector(ThirdPerson.this.xOffset, 0.0f, 0.0f);
                            target.rotateY(Math.toRadians(world.getPlayerRotX()));
                            camera.add(target);
                        }
                        return null;
                    }
                };
            }
        });
        HookManager.getInstance().registerHook("com.wurmonline.client.renderer.WorldRender", "getCameraX", null, new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (ThirdPerson.this.tpActive) {
                            RenderVector camera = (RenderVector)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"cameraOffset"));
                            World world = (World)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"world"));
                            float x = camera.getX();
                            float y = camera.getY();
                            float z = camera.getZ();
                            double yaw = Math.atan2(z, x);
                            ThirdPerson.this.setPitch(world.getPlayerRotY());
                            return (double)(ThirdPerson.this.zoomFactor * -ThirdPerson.this.dist) * Math.cos(yaw) * Math.cos(Math.toRadians(ThirdPerson.this.pitch)) + (double)((Float)method.invoke(proxy, args)).floatValue();
                        }
                        return method.invoke(proxy, args);
                    }
                };
            }
        });
        HookManager.getInstance().registerHook("com.wurmonline.client.renderer.WorldRender", "getCameraY", null, new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (ThirdPerson.this.tpActive) {
                            RenderVector camera = (RenderVector)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"cameraOffset"));
                            World world = (World)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"world"));
                            float x = camera.getX();
                            float y = camera.getY();
                            float z = camera.getZ();
                            ThirdPerson.this.setPitch(world.getPlayerRotY());
                            return (double)ThirdPerson.this.zoomFactor * Math.sin(Math.toRadians(ThirdPerson.this.pitch)) + (double)((Float)method.invoke(proxy, args)).floatValue();
                        }
                        return method.invoke(proxy, args);
                    }
                };
            }
        });
        HookManager.getInstance().registerHook("com.wurmonline.client.renderer.WorldRender", "getCameraZ", null, new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (ThirdPerson.this.tpActive) {
                            RenderVector camera = (RenderVector)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"cameraOffset"));
                            World world = (World)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(proxy.getClass(), (String)"world"));
                            float x = camera.getX();
                            float y = camera.getY();
                            float z = camera.getZ();
                            double yaw = Math.atan2(z, x);
                            ThirdPerson.this.setPitch(world.getPlayerRotY());
                            return (double)(ThirdPerson.this.zoomFactor * -ThirdPerson.this.dist) * Math.sin(yaw) * Math.cos(Math.toRadians(ThirdPerson.this.pitch)) + (double)((Float)method.invoke(proxy, args)).floatValue();
                        }
                        return method.invoke(proxy, args);
                    }
                };
            }
        });
        ModConsole.addConsoleListener((ConsoleListener)this);
    }

    public void addZoom(float factor) {
        this.setZoom(this.zoomFactor + factor);
    }

    public void setZoom(float factor) {
        this.zoomFactor = factor;
        if (this.zoomFactor < 0.0f) {
            this.zoomFactor = 0.0f;
        }
        if (this.zoomFactor > 2.5f) {
            this.zoomFactor = 2.5f;
        }
    }

    public void addPitch(float factor) {
        this.setPitch(this.pitch + factor);
    }

    public void setPitch(float factor) {
        this.pitch = factor;
        if (this.pitch < 30.0f) {
            this.pitch = 30.0f;
        }
        if (this.pitch > 89.9f) {
            this.pitch = 89.9f;
        }
    }

    public void toggleTP() {
        this.tpActive = !this.tpActive;
    }

    public boolean handleInput(String string, Boolean aBoolean) {
        if (string != null && string.startsWith("toggle tp")) {
            this.toggleTP();
            return true;
        }
        if (string != null && string.startsWith("tp zoom-in")) {
            this.addZoom(-0.1f);
            return true;
        }
        if (string != null && string.startsWith("tp zoom-out")) {
            this.addZoom(0.1f);
            return true;
        }
        if (string != null && string.startsWith("tp set-xoffset")) {
            String[] tokens = string.split("\\s+");
            if (tokens.length != 3) {
                System.out.println("Format: tp set-xoffset <value>");
            }
            try {
                this.xOffset = Float.parseFloat(tokens[2]);
            }
            catch (NumberFormatException e) {
                System.out.println("Format: tp set-xoffset <value>");
            }
            return true;
        }
        return false;
    }
}

