/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap.renderer;

import com.wurmonline.client.game.World;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRenderer;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRendererCave;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRendererFlat;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRendererIsometric;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRendererTopographic;

public enum RenderType {
    FLAT{

        @Override
        public MapRenderer createMapRenderer(World world) {
            return new MapRendererFlat(world.getNearTerrainBuffer());
        }
    }
    ,
    ISOMETRIC{

        @Override
        public MapRenderer createMapRenderer(World world) {
            return new MapRendererIsometric(world.getNearTerrainBuffer());
        }
    }
    ,
    TOPOGRAPHIC{

        @Override
        public MapRenderer createMapRenderer(World world) {
            return new MapRendererTopographic(world.getNearTerrainBuffer());
        }
    }
    ,
    CAVE{

        @Override
        public MapRenderer createMapRenderer(World world) {
            return new MapRendererCave(world.getCaveBuffer());
        }

        @Override
        public int getMapSize() {
            return 32;
        }
    };

    public static boolean highRes;

    public abstract MapRenderer createMapRenderer(World var1);

    public int getMapSize() {
        if (highRes) {
            return 256;
        }
        return 128;
    }

    static {
        highRes = false;
    }
}

