/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap;

import com.wurmonline.client.game.PlayerPosition;
import com.wurmonline.client.game.TerrainChangeListener;
import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.PickData;
import com.wurmonline.client.renderer.backend.Queue;
import com.wurmonline.client.renderer.cave.CaveBufferChangeListener;
import com.wurmonline.client.renderer.gui.Renderer;
import com.wurmonline.client.resources.textures.ImageTexture;
import com.wurmonline.client.resources.textures.ImageTextureLoader;
import com.wurmonline.client.resources.textures.PreProcessedTextureData;
import com.wurmonline.client.resources.textures.Texture;
import com.wurmonline.client.resources.textures.TextureLoader;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gotti.wurmonline.clientmods.livehudmap.MapLayer;
import org.gotti.wurmonline.clientmods.livehudmap.MapLayerView;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.RenderType;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;

public class LiveMap
implements TerrainChangeListener,
CaveBufferChangeListener {
    private int size;
    private final World world;
    private MapLayerView surface;
    private MapLayerView cave;
    private boolean dirty = true;
    private BufferedImage image;
    private ImageTexture texture;
    private int x;
    private int y;
    private int px = 0;
    private int py = 0;
    private final Method preprocessImage;

    public LiveMap(World world, int size) {
        this.size = size;
        this.world = world;
        this.world.getNearTerrainBuffer().addListener((TerrainChangeListener)this);
        this.world.getCaveBuffer().addCaveBufferListener((CaveBufferChangeListener)this);
        this.surface = new MapLayerView(world, RenderType.FLAT);
        this.cave = new MapLayerView(world, RenderType.CAVE);
        try {
            this.preprocessImage = ReflectionUtil.getMethod(TextureLoader.class, (String)"preprocessImage", (Class[])new Class[]{BufferedImage.class, Boolean.TYPE});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void update(int windowX, int windowY) {
        this.x = windowX;
        this.y = windowY;
        PlayerPosition pos = this.world.getPlayer().getPos();
        if (this.dirty || this.px != pos.getTileX() || this.py != pos.getTileY()) {
            this.px = pos.getTileX();
            this.py = pos.getTileY();
            this.image = this.getLayer().render(this.px, this.py);
            if (this.texture == null) {
                this.texture = ImageTextureLoader.loadNowrapNearestTexture((BufferedImage)this.image, (boolean)false);
            } else {
                try {
                    PreProcessedTextureData data = (PreProcessedTextureData)ReflectionUtil.callPrivateMethod(TextureLoader.class, (Method)this.preprocessImage, (Object[])new Object[]{this.image, true});
                    this.texture.deferInit(data, TextureLoader.Filter.NEAREST, false, false, false);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            this.dirty = false;
        }
    }

    private MapLayerView getLayer() {
        if (this.isSurface()) {
            return this.surface;
        }
        return this.cave;
    }

    private MapLayerView getLayer(MapLayer layer) {
        switch (layer) {
            case SURFACE: {
                return this.surface;
            }
            case CAVE: {
                return this.cave;
            }
        }
        throw new IllegalArgumentException(layer.name());
    }

    public void setRenderer(MapLayer layer, RenderType renderType) {
        this.getLayer(layer).setRenderer(renderType);
        this.dirty = true;
    }

    public void zoomIn() {
        this.getLayer().zoomIn();
        this.dirty = true;
    }

    public void zoomOut() {
        this.getLayer().zoomOut();
        this.dirty = true;
    }

    private boolean isSurface() {
        return this.world.getPlayerLayer() >= 0;
    }

    public void render(Queue queue, float textureX, float textureY, float textureScale) {
        float resultX = textureX / (float)this.size;
        float resultY = textureY / (float)this.size;
        if (this.texture != null) {
            Renderer.texturedQuadAlphaBlend((Queue)queue, (Texture)this.texture, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)this.x, (float)this.y, (float)this.size, (float)this.size, (float)resultX, (float)resultY, (float)textureScale, (float)textureScale);
        }
    }

    public void caveChanged(int paramInt1, int paramInt2, int paramInt3, int paramInt4, boolean paramBoolean) {
        this.dirty = true;
    }

    public void terrainUpdated(int paramInt1, int paramInt2, int paramInt3, int paramInt4, boolean paramBoolean1, boolean paramBoolean2) {
        this.dirty = true;
    }

    public void pick(PickData pickData, float xMouse, float yMouse) {
        this.getLayer().pick(pickData, xMouse, yMouse);
    }
}

