/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.livehudmap;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.gui.HeadsUpDisplay;
import com.wurmonline.client.renderer.gui.LiveMapWindow;
import com.wurmonline.client.renderer.gui.MainMenu;
import com.wurmonline.client.renderer.gui.WindowSerializer;
import com.wurmonline.client.renderer.gui.WurmComponent;
import com.wurmonline.client.settings.SavePosManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.MapRendererCave;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.RenderType;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.interfaces.Configurable;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmClientMod;
import org.gotti.wurmunlimited.modsupport.console.ConsoleListener;
import org.gotti.wurmunlimited.modsupport.console.ModConsole;

public class LiveHudMapMod
implements WurmClientMod,
Initable,
PreInitable,
Configurable,
ConsoleListener {
    private static Logger logger = Logger.getLogger(LiveHudMapMod.class.getName());
    private boolean hiResMap = false;
    private boolean showHiddenOre = false;
    private Object liveMap;

    public void configure(Properties properties) {
        this.hiResMap = Boolean.valueOf(properties.getProperty("hiResMap", String.valueOf(this.hiResMap)));
        this.showHiddenOre = Boolean.valueOf(properties.getProperty("showHiddenOre", String.valueOf(this.showHiddenOre)));
        logger.log(Level.INFO, "hiResMap: " + this.hiResMap);
        logger.log(Level.INFO, "showHiddenOre: " + this.showHiddenOre);
        RenderType.highRes = this.hiResMap;
        MapRendererCave.showHiddenOre = this.showHiddenOre;
    }

    public void preInit() {
    }

    public void init() {
        HookManager.getInstance().registerHook("com.wurmonline.client.renderer.gui.HeadsUpDisplay", "init", "(II)V", new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        method.invoke(proxy, args);
                        LiveHudMapMod.this.initLiveMap((HeadsUpDisplay)proxy);
                        return null;
                    }
                };
            }
        });
        ModConsole.addConsoleListener((ConsoleListener)this);
    }

    private void initLiveMap(final HeadsUpDisplay hud) {
        new Runnable(){

            @Override
            public void run() {
                try {
                    World world = (World)ReflectionUtil.getPrivateField((Object)hud, (Field)ReflectionUtil.getField(hud.getClass(), (String)"world"));
                    LiveMapWindow liveMapWindow = new LiveMapWindow(world);
                    LiveHudMapMod.this.liveMap = (Object)liveMapWindow;
                    MainMenu mainMenu = (MainMenu)ReflectionUtil.getPrivateField((Object)hud, (Field)ReflectionUtil.getField(hud.getClass(), (String)"mainMenu"));
                    mainMenu.registerComponent("Live map", (WurmComponent)liveMapWindow);
                    List components = (List)ReflectionUtil.getPrivateField((Object)hud, (Field)ReflectionUtil.getField(hud.getClass(), (String)"components"));
                    components.add(liveMapWindow);
                    SavePosManager savePosManager = (SavePosManager)ReflectionUtil.getPrivateField((Object)hud, (Field)ReflectionUtil.getField(hud.getClass(), (String)"savePosManager"));
                    savePosManager.registerAndRefresh((WindowSerializer)liveMapWindow, "livemapwindow");
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }.run();
    }

    public boolean handleInput(String string, Boolean silent) {
        if (string != null && string.startsWith("toggle livemap") && this.liveMap instanceof LiveMapWindow) {
            ((LiveMapWindow)((Object)this.liveMap)).toggle();
            return true;
        }
        return false;
    }
}

