/*
 * Decompiled with CFR 0.152.
 */
package com.wurmonline.client.renderer.gui;

import com.wurmonline.client.game.World;
import com.wurmonline.client.options.Options;
import com.wurmonline.client.renderer.PickData;
import com.wurmonline.client.renderer.gui.ButtonListener;
import com.wurmonline.client.renderer.gui.FlexComponent;
import com.wurmonline.client.renderer.gui.LiveMapButton;
import com.wurmonline.client.renderer.gui.LiveMapView;
import com.wurmonline.client.renderer.gui.WButton;
import com.wurmonline.client.renderer.gui.WTextureButton;
import com.wurmonline.client.renderer.gui.WWindow;
import com.wurmonline.client.renderer.gui.WurmArrayPanel;
import com.wurmonline.client.renderer.gui.WurmBorderPanel;
import com.wurmonline.client.renderer.gui.WurmComponent;
import com.wurmonline.client.resources.textures.ImageTexture;
import com.wurmonline.client.resources.textures.ImageTextureLoader;
import com.wurmonline.client.resources.textures.ResourceTexture;
import com.wurmonline.client.resources.textures.ResourceTextureLoader;
import com.wurmonline.client.resources.textures.Texture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.gotti.wurmonline.clientmods.livehudmap.LiveMap;
import org.gotti.wurmonline.clientmods.livehudmap.MapLayer;
import org.gotti.wurmonline.clientmods.livehudmap.renderer.RenderType;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;

public class LiveMapWindow
extends WWindow {
    private WurmBorderPanel mainPanel;
    private LiveMap liveMap;
    private BufferedImage iconImage;
    private LiveMapView liveMapView;

    public LiveMapWindow(World world) {
        super("Live map", true);
        this.setTitle("Live map");
        this.mainPanel = new WurmBorderPanel("Live map");
        this.liveMap = new LiveMap(world, 256);
        this.resizable = false;
        this.iconImage = this.loadIconImage();
        WurmArrayPanel buttons = new WurmArrayPanel("Live map buttons", 0);
        buttons.setInitialSize(32, 256, false);
        buttons.addComponent((FlexComponent)this.createButton("+", "Zoom in", 0, new ButtonListener(){

            public void buttonPressed(WButton p0) {
            }

            public void buttonClicked(WButton p0) {
                LiveMapWindow.this.liveMap.zoomIn();
            }
        }));
        buttons.addComponent((FlexComponent)this.createButton("-", "Zoom out", 1, new ButtonListener(){

            public void buttonPressed(WButton p0) {
            }

            public void buttonClicked(WButton p0) {
                LiveMapWindow.this.liveMap.zoomOut();
            }
        }));
        buttons.addComponent((FlexComponent)this.createButton("Flat", "Flat view", 2, new ButtonListener(){

            public void buttonPressed(WButton p0) {
            }

            public void buttonClicked(WButton p0) {
                LiveMapWindow.this.liveMap.setRenderer(MapLayer.SURFACE, RenderType.FLAT);
            }
        }));
        buttons.addComponent((FlexComponent)this.createButton("3D", "Pseudo 3D view", 3, new ButtonListener(){

            public void buttonPressed(WButton p0) {
            }

            public void buttonClicked(WButton p0) {
                LiveMapWindow.this.liveMap.setRenderer(MapLayer.SURFACE, RenderType.ISOMETRIC);
            }
        }));
        buttons.addComponent((FlexComponent)this.createButton("Topo", "Topographic view", 4, new ButtonListener(){

            public void buttonPressed(WButton p0) {
            }

            public void buttonClicked(WButton p0) {
                LiveMapWindow.this.liveMap.setRenderer(MapLayer.SURFACE, RenderType.TOPOGRAPHIC);
            }
        }));
        this.liveMapView = new LiveMapView("Live map", this.liveMap, 256, 256);
        this.mainPanel.setComponent((FlexComponent)this.liveMapView, 3);
        this.mainPanel.setComponent((FlexComponent)buttons, 1);
        this.setComponent((FlexComponent)this.mainPanel);
        this.setInitialSize(294, 281, false);
        this.layout();
        this.sizeFlags = 3;
    }

    private BufferedImage loadIconImage() {
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("livemapicons.png");
            if (url == null && ((Object)((Object)this)).getClass().getClassLoader() == HookManager.getInstance().getLoader() && (url = HookManager.getInstance().getClassPool().find(LiveMapWindow.class.getName())) != null) {
                String path = url.toString();
                int pos = path.lastIndexOf(33);
                if (pos != -1) {
                    path = path.substring(0, pos) + "!/livemapicons.png";
                }
                url = new URL(path);
            }
            if (url != null) {
                return ImageIO.read(url);
            }
            return null;
        }
        catch (IOException e) {
            Logger.getLogger(LiveMapWindow.class.getName()).log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private WButton createButton(String label, String tooltip, int textureIndex, ButtonListener listener) {
        if (this.iconImage != null) {
            BufferedImage image = this.iconImage.getSubimage(textureIndex * 32, 0, 32, 32);
            ImageTexture texture = ImageTextureLoader.loadNowrapNearestTexture((BufferedImage)image, (boolean)false);
            return new LiveMapButton("", tooltip, 32, 32, (Texture)texture, listener);
        }
        String themeName = Options.guiSkins.options[Options.guiSkins.value()].toLowerCase(Locale.ENGLISH).replace(" ", "");
        ResourceTexture backgroundTexture = ResourceTextureLoader.getTexture((String)("img.gui.button.mainmenu." + themeName));
        return new WTextureButton(label, tooltip, backgroundTexture, listener);
    }

    public void closePressed() {
        hud.toggleComponent((WurmComponent)this);
    }

    public void toggle() {
        hud.toggleComponent((WurmComponent)this);
    }

    public void pick(PickData pickData, int xMouse, int yMouse) {
        if (this.liveMapView.contains(xMouse, yMouse)) {
            this.liveMap.pick(pickData, 1.0f * (float)(xMouse - this.liveMapView.x) / (float)this.liveMapView.width, 1.0f * (float)(yMouse - this.liveMapView.y) / (float)this.liveMapView.width);
        }
    }
}

