/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.custommap;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.gui.WorldMap;
import com.wurmonline.client.renderer.gui.maps.ClusterMap;
import com.wurmonline.client.renderer.gui.maps.Map;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmClientMod;

public class CustomMapMod
implements WurmClientMod,
Initable {
    private static Logger logger = Logger.getLogger(CustomMapMod.class.getName());

    public void init() {
        HookManager.getInstance().registerHook("com.wurmonline.client.game.World", "setServerInformation", null, new InvocationHandlerFactory(){

            public InvocationHandler createInvocationHandler() {
                return new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Object result = method.invoke(proxy, args);
                        try {
                            String mapName = String.valueOf(args[2]);
                            String textureName = "map." + mapName.toLowerCase(Locale.ROOT);
                            WorldMap worldMap = ((World)proxy).getHud().getWorldMap();
                            ClusterMap currentCluster = (ClusterMap)ReflectionUtil.getPrivateField((Object)worldMap, (Field)ReflectionUtil.getField(WorldMap.class, (String)"currentCluster"));
                            List maps = (List)ReflectionUtil.getPrivateField((Object)currentCluster, (Field)ReflectionUtil.getField(ClusterMap.class, (String)"serverMaps"));
                            for (Map map : maps) {
                                if (!map.getTextureName().equalsIgnoreCase(textureName)) continue;
                                return result;
                            }
                            Map map = new Map(mapName, textureName, false, 920, 620);
                            maps.add(map);
                            return result;
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                            return result;
                        }
                    }
                };
            }
        });
    }
}

