/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modsupport.packs;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.gui.WorldMap;
import com.wurmonline.client.renderer.gui.maps.ClusterMap;
import com.wurmonline.client.renderer.gui.maps.MapAnnotation;
import com.wurmonline.client.renderer.gui.maps.MapAnnotationGroup;
import com.wurmonline.client.renderer.gui.maps.MapXml;
import com.wurmonline.client.resources.ResourceUrl;
import com.wurmonline.shared.xml.XmlNode;
import com.wurmonline.shared.xml.XmlParser;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modsupport.ModClient;

class MapsLoader {
    private static Logger logger = Logger.getLogger(MapsLoader.class.getName());
    private static Method mapXmlLoadFromRootNode;
    private WorldMap worldMap = ModClient.getHeadsUpDisplay().getWorldMap();

    public void load(ResourceUrl mapsUnlimited) {
        XmlNode rootNode = null;
        try (InputStream input = mapsUnlimited.openStream();){
            rootNode = XmlParser.parse((InputStream)input);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (rootNode != null) {
            try {
                ClusterMap currentCluster = (ClusterMap)ReflectionUtil.getPrivateField(this.worldMap, ReflectionUtil.getField(WorldMap.class, "currentCluster"));
                final List privateAnnotations = (List)ReflectionUtil.getPrivateField(currentCluster.getCurrentMapsPrivateAnnotations(), ReflectionUtil.getField(MapAnnotationGroup.class, "annotationList"));
                final List villageAnnotations = (List)ReflectionUtil.getPrivateField(currentCluster.getCurrentMapsVillageAnnotations(), ReflectionUtil.getField(MapAnnotationGroup.class, "annotationList"));
                final List allianceAnnotations = (List)ReflectionUtil.getPrivateField(currentCluster.getCurrentMapsAllianceAnnotations(), ReflectionUtil.getField(MapAnnotationGroup.class, "annotationList"));
                final HashMap clusterMapList = (HashMap)ReflectionUtil.callPrivateMethod(MapXml.class, mapXmlLoadFromRootNode, rootNode, this.worldMap);
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (clusterMapList.size() > 0) {
                                for (ClusterMap map : clusterMapList.values()) {
                                    ReflectionUtil.setPrivateField(MapsLoader.this.worldMap, ReflectionUtil.getField(WorldMap.class, "currentCluster"), map);
                                    map.load();
                                }
                                World world = ModClient.getWorld();
                                int cluster = (Integer)ReflectionUtil.getPrivateField(world, ReflectionUtil.getField(World.class, "cluster"));
                                String serverName = (String)ReflectionUtil.getPrivateField(world, ReflectionUtil.getField(World.class, "serverName"));
                                MapsLoader.this.worldMap.setStartingArea(cluster, serverName);
                                ClusterMap currentCluster = (ClusterMap)ReflectionUtil.getPrivateField(MapsLoader.this.worldMap, ReflectionUtil.getField(WorldMap.class, "currentCluster"));
                                HashMap<MapAnnotationGroup, List> annotations = new HashMap<MapAnnotationGroup, List>();
                                annotations.put(currentCluster.getCurrentMapsPrivateAnnotations(), privateAnnotations);
                                annotations.put(currentCluster.getCurrentMapsVillageAnnotations(), villageAnnotations);
                                annotations.put(currentCluster.getCurrentMapsAllianceAnnotations(), allianceAnnotations);
                                for (Map.Entry entry : annotations.entrySet()) {
                                    for (MapAnnotation annotation : (List)entry.getValue()) {
                                        ((MapAnnotationGroup)entry.getKey()).addAnnotation(annotation);
                                    }
                                }
                            }
                        }
                        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                };
                ModClient.runTask(task);
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | InvocationTargetException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    static {
        try {
            mapXmlLoadFromRootNode = ReflectionUtil.getMethod(MapXml.class, "loadFromRootNode");
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new HookException(e);
        }
    }
}

