/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modsupport.console;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modsupport.console.ConsoleListener;

public class ModConsole {
    private static List<ConsoleListener> listeners = new ArrayList<ConsoleListener>();

    public static void preInit() {
    }

    public static void init() {
        try {
            ClassPool classPool = HookManager.getInstance().getClassPool();
            String descriptor = Descriptor.ofMethod(CtClass.voidType, new CtClass[]{classPool.get("java.lang.String"), classPool.get("boolean")});
            HookManager.getInstance().registerHook("com.wurmonline.client.console.WurmConsole", "handleInput2", descriptor, new InvocationHandlerFactory(){

                @Override
                public InvocationHandler createInvocationHandler() {
                    return new InvocationHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            List list = listeners;
                            synchronized (list) {
                                if (args != null && args.length == 2 && args[0] instanceof String && args[1] instanceof Boolean) {
                                    String input = (String)args[0];
                                    Boolean silent = (Boolean)args[1];
                                    for (ConsoleListener listener : listeners) {
                                        if (!listener.handleInput(input, silent)) continue;
                                        return null;
                                    }
                                }
                                return method.invoke(proxy, args);
                            }
                        }
                    };
                }
            });
        }
        catch (NotFoundException e) {
            throw new HookException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConsoleListener(ConsoleListener listener) {
        List<ConsoleListener> list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConsoleListener(ConsoleListener listener) {
        List<ConsoleListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }
}

