/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.dependency;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gotti.wurmunlimited.modloader.dependency.DependencyProvider;

public class DependencyEntry {
    private final String name;
    private final Set<String> requires = new HashSet<String>();
    private final Set<String> conflicts = new HashSet<String>();
    private final Set<String> before = new HashSet<String>();
    private final Set<String> after = new HashSet<String>();
    private final boolean onDemand;

    protected DependencyEntry(DependencyProvider entry) {
        this.name = entry.getName();
        this.requires.addAll(DependencyEntry.parse(entry.getRequires()));
        this.conflicts.addAll(DependencyEntry.parse(entry.getConflicts()));
        this.before.addAll(this.requires);
        this.before.addAll(entry.getBefore());
        this.after.addAll(entry.getAfter());
        this.onDemand = entry.isOnDemand();
    }

    protected static String parse(String input) {
        String[] parts = input.split("@", 2);
        return parts[0];
    }

    protected static Collection<String> parse(Collection<String> input) {
        return input.stream().map(DependencyEntry::parse).collect(Collectors.toList());
    }

    protected Set<String> getRequires() {
        return this.requires;
    }

    protected Set<String> getConflicts() {
        return this.conflicts;
    }

    protected Set<String> getBefore() {
        return this.before;
    }

    protected Set<String> getAfter() {
        return this.after;
    }

    public String getName() {
        return this.name;
    }

    public void addBefore(String name) {
        this.before.add(name.trim());
    }

    public void addAfter(String name) {
        this.after.add(name.trim());
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOnDemand() {
        return this.onDemand;
    }
}

