/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.classhooks;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;

public class InvocationTarget {
    private boolean staticMethod;
    private String methodName;
    private String identifier;
    private Method method;
    private InvocationHandlerFactory invocationHandlerFactory;
    private InvocationHandler invocationHandler;
    private Class<?>[] exceptionTypes;

    public InvocationTarget(InvocationHandlerFactory invocationHandlerFactory, boolean staticMethod, String methodName, String identifier, Class<?>[] exceptionTypes) {
        this.setMethod(null);
        this.setMethodName(methodName);
        this.setStaticMethod(staticMethod);
        this.setIdentifier(identifier);
        this.setInvocationHandlerFactory(invocationHandlerFactory);
        this.setExceptionTypes(exceptionTypes);
    }

    public Method resolveMethod(Class<? extends Object> targetClass) throws NoSuchMethodException {
        if (this.getMethod() != null) {
            return this.getMethod();
        }
        this.method = ReflectionUtil.getMethod(targetClass, this.getMethodName());
        return this.method;
    }

    public InvocationHandler resolveInvocationHandler() {
        if (this.invocationHandler != null) {
            return this.invocationHandler;
        }
        this.invocationHandler = this.invocationHandlerFactory.createInvocationHandler();
        return this.invocationHandler;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public InvocationHandlerFactory getInvocationHandlerFactory() {
        return this.invocationHandlerFactory;
    }

    protected void setInvocationHandlerFactory(InvocationHandlerFactory invocationHandlerFactory) {
        this.invocationHandlerFactory = invocationHandlerFactory;
    }

    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    protected void setExceptionTypes(Class<?>[] exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    protected void setStaticMethod(boolean staticMethod) {
        this.staticMethod = staticMethod;
    }
}

