/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.classhooks;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Loader;
import javassist.NotFoundException;
import org.gotti.wurmunlimited.modloader.callbacks.Callbacks;
import org.gotti.wurmunlimited.modloader.classhooks.ClassHook;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationTarget;

public class HookManager {
    private ClassPool classPool;
    private Loader loader;
    private Map<String, InvocationTarget> invocationTargets = new HashMap<String, InvocationTarget>();
    private static HookManager instance;
    private Callbacks callbacks;
    private static final Logger LOG;

    private HookManager() {
        this.classPool = ClassPool.getDefault();
        this.loader = new Loader(this.classPool){
            private final Set<String> delegateJavaXPackages;
            private final Pattern javaxPackagePattern;
            {
                this.delegateJavaXPackages = Collections.synchronizedSet(new HashSet());
                this.javaxPackagePattern = Pattern.compile("^(?<pkg>javax\\.[^.]+)\\..*$");
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                block25: {
                    int index = name.lastIndexOf(".");
                    if (index != -1) {
                        try {
                            CtClass ctClass;
                            String url;
                            Package pkg = this.getPackage(name.substring(0, index));
                            if (pkg != null || !(url = (ctClass = HookManager.this.classPool.get(name)).getURL().toString()).startsWith("jar:") || url.lastIndexOf("!") == -1) break block25;
                            URL manifestURL = new URL(url.substring(0, url.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF");
                            try (InputStream is = manifestURL.openStream();){
                                Manifest man = new Manifest(is);
                                String specTitle = null;
                                String specVersion = null;
                                String specVendor = null;
                                String implTitle = null;
                                String implVersion = null;
                                String implVendor = null;
                                String path = name.replace('.', '/').concat("/");
                                Attributes attr = man.getAttributes(path);
                                if (attr != null) {
                                    specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                                    specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                                    specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                                    implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                                    implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                                    implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                                }
                                if ((attr = man.getMainAttributes()) != null) {
                                    if (specTitle == null) {
                                        specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                                    }
                                    if (specVersion == null) {
                                        specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                                    }
                                    if (specVendor == null) {
                                        specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                                    }
                                    if (implTitle == null) {
                                        implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                                    }
                                    if (implVersion == null) {
                                        implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                                    }
                                    if (implVendor == null) {
                                        implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                                    }
                                }
                                this.definePackage(ctClass.getPackageName(), specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
                            }
                            catch (IOException iOException) {}
                        }
                        catch (MalformedURLException | NotFoundException exception) {
                            // empty catch block
                        }
                    }
                }
                return super.findClass(name);
            }

            @Override
            protected Class<?> delegateToParent(String classname) throws ClassNotFoundException {
                Matcher matcher = this.javaxPackagePattern.matcher(classname);
                if (!matcher.matches()) {
                    return super.delegateToParent(classname);
                }
                String javaxPackage = matcher.group("pkg");
                if (this.delegateJavaXPackages.contains(javaxPackage)) {
                    return super.delegateToParent(classname);
                }
                try {
                    Class<?> c = super.delegateToParent(classname);
                    this.delegateJavaXPackages.add(javaxPackage);
                    return c;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        };
        this.callbacks = new Callbacks(this.loader, this.classPool);
    }

    public static synchronized HookManager getInstance() {
        if (instance == null) {
            instance = new HookManager();
        }
        return instance;
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public Loader getLoader() {
        return this.loader;
    }

    private static String getUniqueMethodName(CtClass ctClass, String baseName) {
        String methodName;
        HashSet<String> usedNames = new HashSet<String>();
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            usedNames.add(method.getName());
        }
        int i = 1;
        while (usedNames.contains(methodName = String.format("%s$%d", baseName, i++))) {
        }
        return methodName;
    }

    private InvocationTarget createHook(CtClass ctClass, ClassHook classHook) throws NotFoundException, CannotCompileException {
        CtMethod origMethod = classHook.getMethodType() != null ? ctClass.getMethod(classHook.getMethodName(), classHook.getMethodType()) : ctClass.getDeclaredMethod(classHook.getMethodName());
        if (Modifier.isNative(origMethod.getModifiers())) {
            throw new CannotCompileException("native methods can not be hooked");
        }
        boolean isStatic = Modifier.isStatic(origMethod.getModifiers());
        String callee = isStatic ? String.format("%s.class", ctClass.getName()) : "this";
        origMethod.setName(HookManager.getUniqueMethodName(ctClass, classHook.getMethodName()));
        CtMethod newMethod = CtNewMethod.copy(origMethod, classHook.getMethodName(), ctClass, null);
        CtClass[] exceptionTypes = origMethod.getExceptionTypes();
        Class[] exceptionClasses = new Class[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            try {
                exceptionClasses[i] = this.loader.loadClass(exceptionTypes[i].getName());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new CannotCompileException(e);
            }
        }
        InvocationTarget invocationTarget = new InvocationTarget(classHook.getInvocationHandlerFactory(), isStatic, origMethod.getName(), origMethod.getLongName(), exceptionClasses);
        CtClass type = newMethod.getReturnType();
        String typeName = type.getName();
        boolean voidType = "void".equals(typeName);
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        if (!voidType) {
            builder.append("Object result = ");
        }
        builder.append(String.format("%s#getInstance().invoke(%s,\"%s\",$args);\n", HookManager.class.getName(), callee, origMethod.getLongName()));
        if (!voidType) {
            if (!type.isPrimitive()) {
                builder.append(String.format("return (%s)result;\n", typeName));
            } else if (type == CtClass.booleanType) {
                builder.append(String.format("return ((java.lang.Boolean)result).booleanValue();\n", typeName));
            } else if (type == CtClass.byteType) {
                builder.append(String.format("return ((java.lang.Number)result).byteValue();\n", typeName));
            } else if (type == CtClass.shortType) {
                builder.append(String.format("return ((java.lang.Number)result).shortValue();\n", typeName));
            } else if (type == CtClass.intType) {
                builder.append(String.format("return ((java.lang.Number)result).intValue();\n", typeName));
            } else if (type == CtClass.longType) {
                builder.append(String.format("return ((java.lang.Number)result).longValue();\n", typeName));
            } else if (type == CtClass.floatType) {
                builder.append(String.format("return ((java.lang.Number)result).floatValue();\n", typeName));
            } else if (type == CtClass.doubleType) {
                builder.append(String.format("return ((java.lang.Number)result).doubleValue();\n", typeName));
            } else if (type == CtClass.charType) {
                builder.append(String.format("return ((java.lang.Character)result).charValue();\n", typeName));
            }
        }
        builder.append("\n}");
        String body = builder.toString();
        LOG.fine(body);
        newMethod.setBody(body);
        ctClass.addMethod(newMethod);
        return invocationTarget;
    }

    public void registerHook(String className, String methodName, String methodType, InvocationHandlerFactory invocationHandlerFactory) {
        ClassHook classHook = new ClassHook(methodName, methodType, invocationHandlerFactory);
        try {
            CtClass ctClass = this.classPool.get(className);
            InvocationTarget target = this.createHook(ctClass, classHook);
            this.invocationTargets.put(target.getIdentifier(), target);
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    @Deprecated
    public void registerHook(String className, String methodName, String methodType, final InvocationHandler invocationHandler) {
        this.registerHook(className, methodName, methodType, new InvocationHandlerFactory(){

            @Override
            public InvocationHandler createInvocationHandler() {
                return invocationHandler;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object object, String wrappedMethod, Object[] args) throws Throwable {
        InvocationTarget invocationTarget = this.invocationTargets.get(wrappedMethod);
        if (invocationTarget == null) {
            throw new HookException("Uninstrumented method " + wrappedMethod);
        }
        try {
            Method method = invocationTarget.resolveMethod(invocationTarget.isStaticMethod() ? (Class<?>)object : object.getClass());
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            try {
                Object object2 = invocationTarget.resolveInvocationHandler().invoke(object, method, args);
                return object2;
            }
            finally {
                method.setAccessible(accessible);
            }
        }
        catch (Throwable e) {
            Class<?>[] classArray = invocationTarget.getExceptionTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> exceptionType = classArray[n2];
                if (exceptionType.isInstance(e)) {
                    throw e;
                }
                ++n2;
            }
            throw new HookException(e);
        }
    }

    public static <T> T getCallback(String callbackId) {
        return HookManager.getInstance().callbacks.getCallback(callbackId);
    }

    public void addCallback(CtClass targetClass, String callbackName, Object callbackTarget) {
        this.callbacks.addCallback(targetClass, callbackName, callbackTarget);
    }

    public void initCallbacks() {
        this.callbacks.init();
    }

    static {
        LOG = Logger.getLogger(HookManager.class.getName());
    }
}

