/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader.classhooks;

import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;

public class CodeReplacer {
    private CodeAttribute codeAttribute;

    public CodeReplacer(CodeAttribute codeAttribute) {
        this.codeAttribute = codeAttribute;
    }

    public void replaceCode(byte[] search, byte[] replacement) throws NotFoundException, BadBytecode {
        int pos = this.findCode(search);
        if (replacement.length <= search.length) {
            this.writeWithNops(pos, replacement, search.length - replacement.length);
        } else {
            this.writeOverlapping(pos, replacement, replacement.length - search.length);
        }
    }

    private void writeOverlapping(int pos, byte[] replacement, int overlapping) throws BadBytecode {
        CodeIterator codeIterator = this.codeAttribute.iterator();
        codeIterator.insertGap(pos, overlapping);
        codeIterator.write(replacement, pos);
    }

    private void writeWithNops(int pos, byte[] replacement, int gap) {
        byte[] nops = new byte[gap];
        CodeIterator codeIterator = this.codeAttribute.iterator();
        codeIterator.write(replacement, pos);
        codeIterator.write(nops, pos + replacement.length);
    }

    private int findCode(byte[] search) throws NotFoundException {
        byte[] code = this.codeAttribute.getCode();
        int j = 0;
        int backtrack = 0;
        for (int i = 0; i < code.length && j < search.length; ++i) {
            if (code[i] == search[j]) {
                if (j == 0) {
                    backtrack = i;
                }
                if (++j != search.length) continue;
                return backtrack;
            }
            if (j <= 0) continue;
            i = backtrack;
            j = 0;
        }
        throw new NotFoundException("code");
    }
}

