/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gotti.wurmunlimited.modloader.dependency.DependencyProvider;

class ModInfo
implements DependencyProvider {
    private Properties properties;
    private String name;

    public ModInfo(Properties properties, String name) {
        this.properties = properties;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Collection<String> getRequires() {
        List<String> set = this.parseList(this.getProperties().getProperty("depend.requires", ""));
        set.addAll(this.getImport());
        return set;
    }

    @Override
    public Collection<String> getConflicts() {
        return this.parseList(this.getProperties().getProperty("depend.conflicts", ""));
    }

    @Override
    public Collection<String> getBefore() {
        return this.parseList(this.getProperties().getProperty("depend.suggests", ""));
    }

    @Override
    public Collection<String> getAfter() {
        return this.parseList(this.getProperties().getProperty("depend.precedes", ""));
    }

    @Override
    public boolean isOnDemand() {
        return Boolean.parseBoolean(this.getProperties().getProperty("depend.ondemand", "false"));
    }

    public Collection<String> getImport() {
        return this.parseList(this.getProperties().getProperty("depend.import", ""));
    }

    private List<String> parseList(String list) {
        return Arrays.stream(list.split(",")).map(String::trim).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }
}

