/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modloader;

import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.Loader;
import javassist.NotFoundException;
import javassist.Translator;
import org.gotti.wurmunlimited.modloader.AddToListTranslator;

public class DefrostingClassLoader
extends Loader
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(DefrostingClassLoader.class.getName());
    private AddToListTranslator translator = new AddToListTranslator(this::isUnFrozen);
    private ClassPool classPool;

    public DefrostingClassLoader(ClassPool classPool) throws CannotCompileException, NotFoundException {
        super(classPool);
        super.addTranslator(classPool, this.translator);
        this.classPool = classPool;
    }

    private boolean isUnFrozen(String className) {
        try {
            return !this.classPool.get(className).isFrozen();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @Override
    public void addTranslator(ClassPool cp, Translator t) throws NotFoundException, CannotCompileException {
        throw new UnsupportedOperationException("A translator is already active");
    }

    @Override
    public void close() {
        for (String loadedClass : this.translator.getLoadedClasses()) {
            try {
                this.classPool.get(loadedClass).defrost();
            }
            catch (NotFoundException e) {
                LOGGER.log(Level.WARNING, e.getMessage());
            }
        }
    }
}

