/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modcomm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PacketReader
extends DataInputStream {
    public PacketReader(ByteBuffer buffer) {
        super(new ByteBufferBackedInputStream(buffer));
    }

    private static class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        private ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() throws IOException {
            if (this.buf.hasRemaining()) {
                return this.buf.get() & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (this.buf.hasRemaining()) {
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }
            return -1;
        }
    }
}

