/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmunlimited.modcomm;

import com.wurmonline.communication.SocketConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.gotti.wurmunlimited.modcomm.Channel;
import org.gotti.wurmunlimited.modcomm.ModComm;
import org.gotti.wurmunlimited.modcomm.PacketReader;
import org.gotti.wurmunlimited.modcomm.PacketWriter;

public class ModCommHandler {
    public static void handlePacket(ByteBuffer msg) {
        try {
            byte type = msg.get();
            switch (type) {
                case 1: {
                    ModCommHandler.handlePacketMessage(msg);
                    break;
                }
                case 2: {
                    ModCommHandler.handlePacketChannels(msg);
                    break;
                }
                default: {
                    ModComm.logWarning(String.format("Unknown packet from server (%d)", type));
                    break;
                }
            }
        }
        catch (Exception e) {
            ModComm.logException("Error handling packet from server", e);
        }
    }

    public static void startHandshake() {
        ModComm.logInfo(String.format("Starting handshake, reporting %d registered channels", ModComm.channels.size()));
        try (PacketWriter writer = new PacketWriter();){
            writer.writeByte(-100);
            writer.writeByte(2);
            writer.writeByte(1);
            writer.writeInt(ModComm.channels.size());
            for (Channel channel : ModComm.channels.values()) {
                writer.writeUTF(channel.name);
            }
            SocketConnection conn = ModComm.getServerConnection();
            ByteBuffer buff = conn.getBuffer();
            buff.put(writer.getBytes());
            conn.flush();
        }
        catch (IOException e) {
            ModComm.logException("Error in handshake", e);
        }
    }

    private static void handlePacketChannels(ByteBuffer msg) throws IOException {
        try (PacketReader reader = new PacketReader(msg);){
            HashSet<Channel> toActivate = new HashSet<Channel>();
            ModComm.serverVersion = reader.readByte();
            int n = reader.readInt();
            while (n-- > 0) {
                int id = reader.readInt();
                String name = reader.readUTF();
                if (!ModComm.channels.containsKey(name)) continue;
                Channel channel = ModComm.channels.get(name);
                channel.id = id;
                ModComm.idMap.put(id, channel);
                toActivate.add(channel);
            }
            ModComm.logInfo(String.format("Handshake response received, server protocol version is %d, %d channels activated", ModComm.serverVersion, toActivate.size()));
            for (Channel channel : toActivate) {
                try {
                    channel.listener.onServerConnected();
                }
                catch (Exception e) {
                    ModComm.logException(String.format("Error in channel %s onServerConnected", channel.name), e);
                }
            }
        }
    }

    private static void handlePacketMessage(ByteBuffer msg) {
        int id = msg.getInt();
        if (!ModComm.idMap.containsKey(id)) {
            ModComm.logWarning(String.format("Message on unregistered channel %d", id));
            return;
        }
        Channel ch = ModComm.idMap.get(id);
        try {
            ch.listener.handleMessage(msg.slice());
        }
        catch (Exception e) {
            ModComm.logException(String.format("Error in channel handler %s", ch.name), e);
        }
    }
}

