/*
 * Decompiled with CFR 0.152.
 */
package org.gotti.wurmonline.clientmods.serverpacks;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.ItemColorsXml;
import com.wurmonline.client.renderer.effects.CustomParticleEffectXml;
import com.wurmonline.client.renderer.terrain.TerrainTexture;
import com.wurmonline.client.renderer.terrain.TilePropertiesXml;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.gotti.wurmonline.clientmods.serverpacks.PackDownloader;
import org.gotti.wurmunlimited.modcomm.Channel;
import org.gotti.wurmunlimited.modcomm.IChannelListener;
import org.gotti.wurmunlimited.modcomm.ModComm;
import org.gotti.wurmunlimited.modcomm.PacketReader;
import org.gotti.wurmunlimited.modcomm.PacketWriter;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmClientMod;
import org.gotti.wurmunlimited.modsupport.ModClient;
import org.gotti.wurmunlimited.modsupport.console.ConsoleListener;
import org.gotti.wurmunlimited.modsupport.console.ModConsole;
import org.gotti.wurmunlimited.modsupport.packs.ModPacks;

public class ServerPacksMod
implements WurmClientMod,
Initable,
PreInitable,
ConsoleListener {
    private static final ModPacks.Options[] OPTIONS_DEFAULT = new ModPacks.Options[0];
    private static final ModPacks.Options[] OPTIONS_PREPEND = new ModPacks.Options[]{ModPacks.Options.PREPEND};
    private static final String CONSOLE_PREFIX = "mod serverpacks";
    private static final byte CMD_REFRESH = 1;
    private Logger logger = Logger.getLogger(ServerPacksMod.class.getName());
    private Channel channel = null;

    public void preInit() {
        try {
            ClassPool classPool = HookManager.getInstance().getClassPool();
            CtClass ctResources = classPool.get("com.wurmonline.client.resources.Resources");
            CtClass ctPack = classPool.get("com.wurmonline.client.resources.Pack");
            CtClass ctPackResourceUrl = classPool.get("com.wurmonline.client.resources.PackResourceUrl");
            CtMethod findPackMethod = new CtMethod(ctPack, "findPack", new CtClass[]{classPool.get("java.lang.String")}, ctResources);
            findPackMethod.setBody("{        for (java.util.Iterator iterator = this.packs.iterator(); iterator.hasNext(); ) {            com.wurmonline.client.resources.Pack pack = (com.wurmonline.client.resources.Pack) iterator.next();            if (pack.getName().equals($1)) return pack;        }        return null;}");
            ctResources.addMethod(findPackMethod);
            ctPackResourceUrl.getDeclaredField("rawFilePath").setModifiers(1);
            ctPack.getMethod("init", "(Lcom/wurmonline/client/resources/Resources;)V").instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getMethodName().equals("exists")) {
                        m.replace("$_ = $0.getFilePath().startsWith(\"~\") || $proceed();");
                    }
                }
            });
            ctPack.getMethod("getResource", "(Ljava/lang/String;)Lcom/wurmonline/client/resources/ResourceUrl;").insertAfter("if ($_ != null && ($_ instanceof com.wurmonline.client.resources.PackResourceUrl) && $_.getFilePath().startsWith(\"~\")) {    \tint sep = $_.getFilePath().indexOf('/');       com.wurmonline.client.resources.Pack pack = com.wurmonline.client.WurmClientBase.getResourceManager()\t\t\t.findPack($_.getFilePath().substring(1,sep));       if (pack!=null)       \t$_ = new com.wurmonline.client.resources.PackResourceUrl(pack, ((com.wurmonline.client.resources.PackResourceUrl)$_).rawFilePath.substring(sep+1).replace(\"~[local]/\",\"~\"+this.name+\"/\"));     };");
            ctPackResourceUrl.getMethod("derive", "(Ljava/lang/String;)Lcom/wurmonline/client/resources/PackResourceUrl;").insertBefore("if ($1.startsWith(\"~\")) {\n\t\t\tint sep = $1.indexOf('/');\n           com.wurmonline.client.resources.Pack pack = com.wurmonline.client.WurmClientBase.getResourceManager()\t\t\t\t.findPack(newFilename.substring(1,sep));           if (pack!=null) {\t\t\t\tcom.wurmonline.client.resources.PackResourceUrl nurl = new com.wurmonline.client.resources.PackResourceUrl(pack, $1.substring(sep+1));\t\t\t\tif (!nurl.exists()) throw com.wurmonline.client.GameCrashedException.forFailure(\"Derived cross-pack resource \" + nurl + \" does not exist (source \" + this + \")\");           \treturn nurl;\t\t\t}\t\t}");
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void init() {
        try {
            this.channel = ModComm.registerChannel((String)"ago.serverpacks", (IChannelListener)new IChannelListener(){

                public void handleMessage(ByteBuffer message) {
                    try (PacketReader reader = new PacketReader(message);){
                        int n = reader.readInt();
                        while (n-- > 0) {
                            String packId = reader.readUTF();
                            String uri = reader.readUTF();
                            ServerPacksMod.this.logger.log(Level.INFO, String.format("Got server pack %s (%s)", packId, uri));
                            ServerPacksMod.this.installServerPack(packId, uri);
                        }
                        ServerPacksMod.this.refreshModels();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            ClassPool classPool = HookManager.getInstance().getClassPool();
            String descriptor = Descriptor.ofMethod((CtClass)classPool.get("com.wurmonline.client.resources.ResourceUrl"), (CtClass[])new CtClass[]{classPool.get("java.lang.String")});
            HookManager.getInstance().registerHook("com.wurmonline.client.resources.Resources", "findResource", descriptor, new InvocationHandlerFactory(){

                public InvocationHandler createInvocationHandler() {
                    return new InvocationHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object object = proxy;
                            synchronized (object) {
                                method.setAccessible(true);
                                return method.invoke(proxy, args);
                            }
                        }
                    };
                }
            });
            ModConsole.addConsoleListener((ConsoleListener)this);
        }
        catch (NotFoundException e) {
            throw new HookException((Throwable)e);
        }
    }

    private void installServerPack(String packId, String packUri) {
        try {
            URL packUrl = new URL(packUri);
            boolean force = Boolean.parseBoolean(this.splitQuery(packUrl).getOrDefault("force", Collections.emptyList()).stream().map(v -> v == null ? "true" : v).reduce((a, b) -> b).orElse("false"));
            if (force || !this.checkForExistingPack(packId)) {
                this.downloadPack(packUrl, packId);
            } else {
                this.enableDownloadedPack(packId, packUrl);
            }
        }
        catch (MalformedURLException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Map<String, List<String>> splitQuery(URL url) {
        if (url == null || url.getQuery() == null || url.getQuery().isEmpty()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(url.getQuery().split("&")).map(this::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        try {
            int idx = it.indexOf("=");
            String key = idx > 0 ? it.substring(0, idx) : it;
            String value = idx > 0 && it.length() > idx + 1 ? URLDecoder.decode(it.substring(idx + 1), "UTF-8") : null;
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void enableDownloadedPack(String packId, URL packUrl) {
        boolean prepend;
        File file = Paths.get("packs", this.getPackName(packId)).toFile();
        if (ModPacks.addPack((File)file, (ModPacks.Options[])((prepend = Boolean.parseBoolean(this.splitQuery(packUrl).getOrDefault("prepend", Collections.emptyList()).stream().map(v -> v == null ? "true" : v).reduce((a, b) -> b).orElse("false"))) ? OPTIONS_PREPEND : OPTIONS_DEFAULT))) {
            this.logger.log(Level.INFO, "Added server pack " + packId);
            CustomParticleEffectXml.reloadParticlesFile();
            ItemColorsXml.reloadItemColors((World)ModClient.getWorld());
            TilePropertiesXml.reloadTiles();
            TerrainTexture.reloadNormalMaps();
        }
    }

    private void downloadPack(final URL packUrl, String packId) {
        PackDownloader downloader = new PackDownloader(packUrl, packId){

            @Override
            protected void done(String packId, Path tempFile) {
                ModClient.runTask(() -> {
                    try {
                        Path packFile = Paths.get("packs", ServerPacksMod.this.getPackName(packId));
                        ModPacks.closePack((File)packFile.toFile());
                        Files.move(tempFile, packFile, StandardCopyOption.REPLACE_EXISTING);
                        ServerPacksMod.this.enableDownloadedPack(packId, packUrl);
                        ServerPacksMod.this.refreshModels();
                    }
                    catch (IOException e) {
                        ServerPacksMod.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                });
            }
        };
        new Thread(downloader).start();
    }

    private boolean checkForExistingPack(String packId) {
        Path path = Paths.get("packs", this.getPackName(packId));
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private String getPackName(String packId) {
        return packId + ".jar";
    }

    private void refreshModels() {
        if (this.channel != null) {
            try (PacketWriter writer = new PacketWriter();){
                writer.writeByte(1);
                this.channel.sendMessage(writer.getBytes());
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void handleConsoleInput(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, " ");
        if (tokenizer.hasMoreTokens()) {
            String cmd = tokenizer.nextToken();
            switch (cmd.toLowerCase()) {
                case "installpack": {
                    String id = null;
                    String url = null;
                    if (tokenizer.hasMoreTokens()) {
                        id = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        url = tokenizer.nextToken();
                    }
                    if (id != null && url != null) {
                        this.installServerPack(id, url);
                        break;
                    }
                    this.printConsoleHelp();
                    break;
                }
                case "refresh": {
                    this.refreshModels();
                    break;
                }
                default: {
                    this.printConsoleHelp();
                    break;
                }
            }
        } else {
            this.printConsoleHelp();
        }
        String[] s = string.split(" ", 5);
        if (s.length == 5) {
            this.installServerPack(s[3], s[4]);
            this.refreshModels();
        }
    }

    private void printConsoleHelp() {
        System.out.println("Mod serverpacks console usage:");
        System.out.println("mod serverpacks installpack <packid> <url>");
        System.out.println("\tLoad a serverpack");
        System.out.println("mod serverpacks refresh");
        System.out.println("\tRefresh the models");
    }

    public boolean handleInput(String string, Boolean silent) {
        if (string != null && string.startsWith(CONSOLE_PREFIX)) {
            this.handleConsoleInput(string.substring(CONSOLE_PREFIX.length()).trim());
            return true;
        }
        return false;
    }
}

