/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.compass;

import com.wurmonline.client.game.World;
import com.wurmonline.client.renderer.PickData;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modloader.ReflectionUtil;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.classhooks.InvocationHandlerFactory;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmMod;

public class CompassMod
implements WurmMod,
Initable,
PreInitable {
    private static Logger logger = Logger.getLogger("CompassMod");

    public void init() {
        logger.fine("Initializing");
        try {
            HookManager.getInstance().registerHook("com.wurmonline.client.renderer.gui.CompassComponent", "gameTick", "()V", new InvocationHandlerFactory(){

                public InvocationHandler createInvocationHandler() {
                    return new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            method.invoke(proxy, args);
                            Class<?> cls = proxy.getClass();
                            ReflectionUtil.setPrivateField((Object)proxy, (Field)ReflectionUtil.getField(cls, (String)"isMoving"), (Object)false);
                            ReflectionUtil.setPrivateField((Object)proxy, (Field)ReflectionUtil.getField(cls, (String)"fadeAlpha"), (Object)Float.valueOf(1.0f));
                            return null;
                        }
                    };
                }
            });
            HookManager.getInstance().registerHook("com.wurmonline.client.renderer.gui.CompassComponent", "pick", "(Lcom/wurmonline/client/renderer/PickData;II)V", new InvocationHandlerFactory(){

                public InvocationHandler createInvocationHandler() {
                    return new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            method.invoke(proxy, args);
                            Class<?> cls = proxy.getClass();
                            PickData pickData = (PickData)args[0];
                            World world = (World)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(cls, (String)"world"));
                            float prettyAngle = ((Float)ReflectionUtil.getPrivateField((Object)proxy, (Field)ReflectionUtil.getField(cls, (String)"actualAngle"))).floatValue() % 360.0f;
                            if (prettyAngle < 0.0f) {
                                prettyAngle += 360.0f;
                            }
                            pickData.addText("Angle: " + prettyAngle);
                            pickData.addText(String.format("Position: %.1f / %.1f", Float.valueOf(world.getPlayer().getPos().getX() / 4.0f), Float.valueOf(world.getPlayer().getPos().getY() / 4.0f)));
                            pickData.addText(String.format("Height: %.1f", Float.valueOf(world.getPlayer().getPos().getH() * 10.0f)));
                            return null;
                        }
                    };
                }
            });
            logger.fine("Loaded");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error loading mod", e);
        }
    }

    public void preInit() {
    }
}

