/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.waxed;

import com.wurmonline.server.FailedException;
import com.wurmonline.server.Items;
import com.wurmonline.server.NoSuchItemException;
import com.wurmonline.server.Server;
import com.wurmonline.server.behaviours.Action;
import com.wurmonline.server.behaviours.ActionEntry;
import com.wurmonline.server.behaviours.Actions;
import com.wurmonline.server.creatures.Creature;
import com.wurmonline.server.items.Item;
import com.wurmonline.server.items.ItemFactory;
import com.wurmonline.server.items.ItemTemplate;
import com.wurmonline.server.items.ItemTemplateFactory;
import com.wurmonline.server.items.NoSuchTemplateException;
import com.wurmonline.server.skills.Skill;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.bdew.wurm.waxed.AdvancedItemIdParser;
import net.bdew.wurm.waxed.WaxedItem;
import net.bdew.wurm.waxed.WaxedMod;
import org.gotti.wurmunlimited.modsupport.actions.ActionPerformer;
import org.gotti.wurmunlimited.modsupport.actions.ActionPropagation;
import org.gotti.wurmunlimited.modsupport.actions.BehaviourProvider;
import org.gotti.wurmunlimited.modsupport.actions.ModAction;
import org.gotti.wurmunlimited.modsupport.actions.ModActions;

public class MakeWaxedAction
implements ModAction,
ActionPerformer,
BehaviourProvider {
    private ActionEntry actionEntry = ActionEntry.createEntry((short)((short)ModActions.getNextActionId()), (String)"Preserve", (String)"waxing", (int[])new int[]{1, 4, 6, 48, 36});
    private final Set<Integer> extraItems;

    public MakeWaxedAction(String extra) {
        ModActions.registerAction((ActionEntry)this.actionEntry);
        AdvancedItemIdParser parser = new AdvancedItemIdParser();
        this.extraItems = parser.parseListSafe(extra);
        this.extraItems.forEach(n -> {
            try {
                ItemTemplate tpl = ItemTemplateFactory.getInstance().getTemplate(n.intValue());
                WaxedMod.logInfo(String.format("Added extra item: %s", tpl.getName()));
            }
            catch (NoSuchTemplateException e) {
                WaxedMod.logWarning(String.format("Extra item %d is missing", n));
            }
        });
    }

    public short getActionId() {
        return this.actionEntry.getNumber();
    }

    public BehaviourProvider getBehaviourProvider() {
        return this;
    }

    public ActionPerformer getActionPerformer() {
        return this;
    }

    public boolean canUse(Creature performer, Item source, Item target) {
        return performer.isPlayer() && source != null && target != null && source.getTemplateId() == 1254 && (target.isFood() && !target.isLiquid() || this.extraItems.contains(target.getTemplateId())) && source.getTopParent() == performer.getInventory().getWurmId() && target.getTopParent() == performer.getInventory().getWurmId() && !source.isTraded() && !target.isTraded() && !target.isNoDrop();
    }

    public List<ActionEntry> getBehavioursFor(Creature performer, Item source, Item target) {
        if (this.canUse(performer, source, target)) {
            return Collections.singletonList(this.actionEntry);
        }
        return null;
    }

    public boolean action(Action action, Creature performer, Item source, Item target, short num, float counter) {
        if (!this.canUse(performer, source, target)) {
            performer.getCommunicator().sendAlertServerMessage("You can't do that now.");
            return this.propagate(action, new ActionPropagation[]{ActionPropagation.FINISH_ACTION, ActionPropagation.NO_SERVER_PROPAGATION, ActionPropagation.NO_ACTION_PERFORMER_PROPAGATION});
        }
        if (source.getWeightGrams() < target.getWeightGrams() / 10) {
            performer.getCommunicator().sendNormalServerMessage(String.format("You need at least %d grams of wax to preserve the %s.", target.getWeightGrams() / 10, target.getName()));
            return this.propagate(action, new ActionPropagation[]{ActionPropagation.FINISH_ACTION, ActionPropagation.NO_SERVER_PROPAGATION, ActionPropagation.NO_ACTION_PERFORMER_PROPAGATION});
        }
        if (counter == 1.0f) {
            performer.getCommunicator().sendNormalServerMessage(String.format("You start waxing %s to preserve it.", target.getNameWithGenus()));
            Server.getInstance().broadCastAction(String.format("%s starts waxing %s.", performer.getName(), target.getName()), performer, 5);
            action.setTimeLeft(Actions.getQuickActionTime((Creature)performer, (Skill)performer.getSkills().getSkillOrLearn(1018), (Item)source, (double)0.0));
            performer.sendActionControl("waxing", true, action.getTimeLeft());
        } else if (counter * 10.0f > (float)action.getTimeLeft()) {
            try {
                Item waxed = ItemFactory.createItem((int)WaxedItem.waxedItemId, (float)target.getCurrentQualityLevel(), (byte)target.getRarity(), (String)performer.getName());
                Item parent = target.getParent();
                waxed.setRealTemplate(target.getTemplateId());
                waxed.setName(this.formatWaxedName(target.getName()));
                waxed.setSizes(target.getSizeX(), target.getSizeY(), target.getSizeZ());
                waxed.setWeight(target.getWeightGrams(), false);
                waxed.setMaterial(target.getMaterial());
                source.setWeight(source.getWeightGrams() - target.getWeightGrams() / 10, true);
                parent.dropItem(target.getWurmId(), false);
                Items.destroyItem((long)target.getWurmId());
                parent.insertItem(waxed, true, false);
            }
            catch (FailedException | NoSuchItemException | NoSuchTemplateException e) {
                performer.getCommunicator().sendAlertServerMessage("Something went wrong, try again later or open a /support ticket.");
                WaxedMod.logException("Error waxing item", e);
                return this.propagate(action, new ActionPropagation[]{ActionPropagation.FINISH_ACTION, ActionPropagation.NO_SERVER_PROPAGATION, ActionPropagation.NO_ACTION_PERFORMER_PROPAGATION});
            }
            performer.getCommunicator().sendNormalServerMessage(String.format("You finish waxing %s, it is no longer edible but won't spoil now. You used %d grams of wax.", target.getNameWithGenus(), target.getWeightGrams() / 10));
            Server.getInstance().broadCastAction(String.format("%s finishes waxing %s.", performer.getName(), target.getName()), performer, 5);
            return this.propagate(action, new ActionPropagation[]{ActionPropagation.FINISH_ACTION, ActionPropagation.NO_SERVER_PROPAGATION, ActionPropagation.NO_ACTION_PERFORMER_PROPAGATION});
        }
        return this.propagate(action, new ActionPropagation[]{ActionPropagation.CONTINUE_ACTION});
    }

    private String formatWaxedName(String originalName) {
        StringBuilder bob = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(originalName, " ");
        int ct = 0;
        while (toks.hasMoreTokens()) {
            String word = toks.nextToken();
            if (ct++ > 0) {
                bob.append(" ");
            }
            String first = word.substring(0, 1).toUpperCase();
            bob.append(first);
            bob.append(word.substring(1));
        }
        return bob.toString();
    }
}

