/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.wurm.waxed;

import com.wurmonline.server.items.ItemTemplateFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bdew.wurm.waxed.WaxedMod;
import org.gotti.wurmunlimited.modsupport.IdFactory;
import org.gotti.wurmunlimited.modsupport.IdType;
import org.gotti.wurmunlimited.modsupport.items.ItemIdParser;

public class AdvancedItemIdParser
extends ItemIdParser {
    private Map<String, Integer> idMap = new HashMap<String, Integer>();

    public AdvancedItemIdParser() {
        IdFactory.getIdsFor((IdType)IdType.ITEMTEMPLATE).forEach(e -> {
            Integer n = this.idMap.put((String)e.getKey(), (Integer)e.getValue());
        });
    }

    protected int unparsable(String name) {
        Integer res = this.idMap.get(name);
        if (res != null) {
            return res;
        }
        return super.unparsable(name);
    }

    public Stream<Integer> parseSafe(String name) {
        try {
            return Stream.of(Integer.valueOf(this.parse(name)));
        }
        catch (Exception e) {
            WaxedMod.logWarning(String.format("Error parsing item id '%s': %s", name, e.toString()));
            return Stream.empty();
        }
    }

    public Set<Integer> parseListSafe(String str) {
        return Arrays.stream(str.split(",")).map(String::trim).flatMap(this::parseSafe).filter(i -> ItemTemplateFactory.getInstance().getTemplateOrNull(i.intValue()) != null).collect(Collectors.toSet());
    }
}

