/*
 * Decompiled with CFR 0.152.
 */
package brs.wurm.mod.server.milkfix;

import com.wurmonline.server.creatures.Communicator;
import com.wurmonline.server.creatures.Creature;
import com.wurmonline.server.creatures.Creatures;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gotti.wurmunlimited.modloader.interfaces.Configurable;
import org.gotti.wurmunlimited.modloader.interfaces.PlayerMessageListener;
import org.gotti.wurmunlimited.modloader.interfaces.WurmServerMod;

public class MilkFix
implements PlayerMessageListener,
WurmServerMod,
Configurable {
    static Logger logger = Logger.getLogger(MilkFix.class.getName());
    private int milkHours;
    private int shearHours;
    private int milkingInterval;
    private int shearingInterval;
    long lastMilkableReset = System.currentTimeMillis();
    long lastShearableReset = System.currentTimeMillis();

    public static void main(String[] args) throws InterruptedException {
        MilkFix instance = new MilkFix();
        Properties props = new Properties();
        props.setProperty("milkhours", "3");
        props.setProperty("shearhours", "168");
        instance.configure(props);
        System.out.println(instance.getTimeToMilk());
        instance.lastMilkableReset -= 60000L;
        System.out.println(instance.getTimeToMilk());
        instance.lastMilkableReset -= 3900000L;
        System.out.println(instance.getTimeToMilk());
        System.out.println(instance.getTimeToShear());
        Thread.sleep(2000L);
    }

    private void startThreads() {
        if (this.milkHours > 0) {
            this.startMilkingThread();
        }
        if (this.shearHours > 0) {
            this.startShearingThread();
        }
    }

    private void startMilkingThread() {
        Thread milkingThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(MilkFix.this.milkingInterval);
                            MilkFix.this.resetMilk();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info("Milking thread interrupted.");
                        continue;
                    }
                    break;
                }
            }
        };
        milkingThread.setDaemon(true);
        milkingThread.start();
        logger.info("Milking timer started.");
    }

    private void startShearingThread() {
        Thread shearingThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(MilkFix.this.shearingInterval);
                            MilkFix.this.resetShear();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info("Shearing thread interrupted.");
                        continue;
                    }
                    break;
                }
            }
        };
        shearingThread.setDaemon(true);
        shearingThread.start();
        logger.info("Shearing timer started.");
    }

    public String getVersion() {
        return "v1.0";
    }

    public void configure(Properties properties) {
        String hours = properties.getProperty("milkhours", "0");
        try {
            this.milkHours = Math.max(0, Integer.parseInt(hours));
        }
        catch (NumberFormatException e) {
            logger.info("Invalid milkhours value: " + hours);
        }
        hours = properties.getProperty("shearhours", "0");
        try {
            this.shearHours = Math.max(0, Integer.parseInt(hours));
        }
        catch (NumberFormatException e) {
            logger.info("Invalid shearhours value: " + hours);
        }
        this.milkingInterval = 3600000 * this.milkHours;
        this.shearingInterval = 3600000 * this.shearHours;
        StringBuilder info = new StringBuilder("MilkFix started, ");
        info.append(this.getVersion());
        info.append("\nHours between milking: ");
        info.append(this.milkHours == 0 ? "disabled" : Integer.valueOf(this.milkHours));
        info.append("\nHours between shearing: ");
        info.append(this.shearHours == 0 ? "disabled" : Integer.valueOf(this.shearHours));
        logger.info(info.toString());
        this.startThreads();
    }

    public void resetMilk() {
        logger.log(Level.INFO, "Resetting milking.");
        Creature[] crets = Creatures.getInstance().getCreatures();
        int x = 0;
        while (x < crets.length) {
            if (crets[x].isMilkable()) {
                crets[x].setMilked(false);
            }
            ++x;
        }
        this.lastMilkableReset = System.currentTimeMillis();
    }

    public void resetShear() {
        logger.log(Level.INFO, "Resetting shearing.");
        Creature[] crets = Creatures.getInstance().getCreatures();
        int x = 0;
        while (x < crets.length) {
            if (crets[x].isSheared()) {
                crets[x].setSheared(false);
            }
            ++x;
        }
        this.lastShearableReset = System.currentTimeMillis();
    }

    private void addPlural(StringBuilder builder, int value) {
        if (value != 1) {
            builder.append("s");
        }
    }

    private void addTimeFrame(StringBuilder builder, String type, int value) {
        builder.append(value);
        builder.append(" ");
        builder.append(type);
        this.addPlural(builder, value);
    }

    private String getTimeToReset(String type, long lastReset, long interval) {
        if (interval == 0L) {
            return String.valueOf(type) + " fix is disabled.";
        }
        long millis = interval - (System.currentTimeMillis() - lastReset);
        long totalMinutes = Math.floorDiv(millis, 60000L);
        int days = (int)Math.floorDiv(totalMinutes, 1440L);
        totalMinutes = (int)Math.floorMod(totalMinutes, 1440L);
        int hours = (int)Math.floorDiv(totalMinutes, 60L);
        int minutes = (int)Math.floorMod(totalMinutes, 60L);
        StringBuilder bob = new StringBuilder("Time before next ");
        bob.append(type);
        bob.append(" reset: ");
        if (days > 0) {
            this.addTimeFrame(bob, "day", days);
            bob.append(", ");
        }
        if (hours > 0) {
            this.addTimeFrame(bob, "hour", hours);
            bob.append(", ");
        }
        this.addTimeFrame(bob, "minute", minutes);
        return bob.toString();
    }

    private String getTimeToMilk() {
        return this.getTimeToReset("milking", this.lastMilkableReset, this.milkingInterval);
    }

    private String getTimeToShear() {
        return this.getTimeToReset("shearing", this.lastShearableReset, this.shearingInterval);
    }

    public boolean onPlayerMessage(Communicator communicator, String msg) {
        if ((msg = msg.toLowerCase()).startsWith("/milk")) {
            communicator.sendNormalServerMessage(this.getTimeToMilk());
        } else if (msg.startsWith("/shear")) {
            communicator.sendNormalServerMessage(this.getTimeToShear());
        } else {
            return false;
        }
        return true;
    }
}

