/*
 * Decompiled with CFR 0.152.
 */
package brs.wurm.mod.server.lifex;

import com.wurmonline.server.WurmCalendar;
import com.wurmonline.server.creatures.CreatureStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import org.gotti.wurmunlimited.modloader.callbacks.CallbackApi;
import org.gotti.wurmunlimited.modloader.classhooks.HookException;
import org.gotti.wurmunlimited.modloader.classhooks.HookManager;
import org.gotti.wurmunlimited.modloader.interfaces.Configurable;
import org.gotti.wurmunlimited.modloader.interfaces.Initable;
import org.gotti.wurmunlimited.modloader.interfaces.PreInitable;
import org.gotti.wurmunlimited.modloader.interfaces.WurmServerMod;
import org.gotti.wurmunlimited.modsupport.creatures.CreatureTemplateParser;

public class CreatureLifeExtender
implements WurmServerMod,
Configurable,
Initable,
PreInitable {
    private static final long ORIG_CREATURE_POLL_TIMER = 2419200L;
    private static final long INTERVAL_TIMER = 19353600L;
    private static final long REAL_DAYS = 28L;
    private static int extensionAge = 8;
    private static Set<Integer> excludedTemplates = new HashSet<Integer>(Arrays.asList(37, 40, 86, 39, 69, 87));
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public static void main(String[] args) {
        new CreatureLifeExtender().configure(null);
    }

    public String getVersion() {
        return "1.0";
    }

    public void configure(Properties properties) {
        CreatureTemplateParser parser = new CreatureTemplateParser(){

            protected int unparsable(String name) {
                CreatureLifeExtender.this.logger.warning("Invalid template " + name);
                return -1;
            }
        };
        this.logger.log(Level.INFO, "Growth slows at age: " + extensionAge);
        this.logger.log(Level.INFO, "Real days between aging: 28");
        this.logger.log(Level.INFO, "Excluded templates: " + parser.toString(excludedTemplates.stream().mapToInt(Integer::intValue).toArray()));
    }

    @CallbackApi
    public long getAdjustedLastPolledAge(CreatureStatus creatureStatus, boolean reborn) {
        boolean creatureQualifies;
        int age = creatureStatus.age;
        int templateId = creatureStatus.getTemplate().getTemplateId();
        boolean bl = creatureQualifies = !reborn && age >= extensionAge && !excludedTemplates.contains(templateId);
        if (creatureQualifies) {
            long timeSinceLastPoll = WurmCalendar.currentTime - creatureStatus.lastPolledAge;
            if (timeSinceLastPoll < 19353600L) {
                return WurmCalendar.currentTime - 2419200L + 10L;
            }
            StringBuilder bob = new StringBuilder("Increasing age for ");
            bob.append(creatureStatus.getTemplate().getName());
            bob.append(" from ");
            bob.append(age);
            bob.append(", at ");
            bob.append((int)(creatureStatus.getPositionX() / 4.0f));
            bob.append(", ");
            bob.append((int)(creatureStatus.getPositionY() / 4.0f));
            bob.append("; prev=");
            bob.append(creatureStatus.lastPolledAge);
            bob.append(", time=");
            bob.append(timeSinceLastPoll);
            this.logger.log(Level.INFO, bob.toString());
        }
        return creatureStatus.lastPolledAge;
    }

    public void preInit() {
        try {
            CtClass ctCreatureStatus = HookManager.getInstance().getClassPool().get("com.wurmonline.server.creatures.CreatureStatus");
            HookManager.getInstance().addCallback(ctCreatureStatus, "creatureagemod", (Object)this);
            CtMethod method = ctCreatureStatus.getMethod("pollAge", "(I)Z");
            method.instrument(new ExprEditor(){

                public void edit(FieldAccess f) throws CannotCompileException {
                    if ("lastPolledAge".equals(f.getFieldName())) {
                        f.replace("$_ = creatureagemod.getAdjustedLastPolledAge(this, reborn);");
                    }
                }
            });
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new HookException(e);
        }
    }

    public void init() {
    }
}

